A=imread("pianeta.jpg"); %carico l'immagine

%definisco i filtri imponendo le condizioni dell'esercizio 6 
u=size(A);
righe=u(1);
colonne=u(2);
fr=ones(1,righe);
fc=ones(1,colonne);

for j=1:round(righe/2)
    %applico il filtro passa basso prendendo come potenza k=3
    fr(j)=(1+cos((2*pi*j/righe)))^3;
    fr(righe+1-j)=(1+cos((2*pi*j/righe)))^3;
end

for j=1:round((colonne/2))
    fc(j)=(1+cos((2*pi*j/colonne)))^3;
    fc(colonne+1-j)=(1+cos((2*pi*j/colonne)))^3;
end

%trasformo variabile intera in double
B=double(A);
% calcolo fft di righe e colonne
for i=1:3
    v=fft2(double(A(:,:,i)));
     %filtro e antitrasformo
     v=diag(fr)*v*diag(fc);
    v=ifft2(v);
    % tolgo eventuale roundoff immaginario
    B(:,:,i)=real(v);
end
imwrite(B, 'pianetafiltrato.jpg') %salvo l'immagine filtrata

%rendo più scura l'immagine
mx=max(max(max(B)));
fattore=900.0/mx;
B=B*fattore;
B=uint8(B);
imshow(B);
imwrite(B, 'pianetafinale.jpg') %salvo l'immagine scurita e filtrata

    
