# include <stdio.h>
# include <stdlib.h>

struct nodoAlberoBinario {
  int info ;
  struct nodoAlberoBinario * left ;
  struct nodoAlberoBinario * right ;
};
typedef struct nodoAlberoBinario NodoAlbero ;
typedef NodoAlbero * AlberoBinario ;

/* DICHIARAZIONE DELLE FUNZIONI / PROCEDURE DA DEFINIRE */
void insert ( AlberoBinario * radice , int val ) ;
int kth ( AlberoBinario radice , int k ) ;

/* PROCEDURA PER RILASCIARE LA MEMORIA */
void free_tree ( AlberoBinario radice )
{
  if ( radice != NULL ) {
    free_tree ( radice -> left ) ;
    free_tree ( radice -> right ) ;
    free ( radice ) ;
  }
}

/* MAIN */
int main ( void )
{
  int i , n , k , num ;
  AlberoBinario radice = NULL ;
  scanf ("%d", & n ) ;
  for ( i = 0; i < n ; ++ i ) {
    scanf ("%d", & num ) ;
    insert (& radice , num ) ;
  }
  scanf ("%d" ,& k ) ;
  printf ("%d\n", kth ( radice , k ) ) ;
  free_tree ( radice ) ;
  return 0;
}





void insert(AlberoBinario* ptx_root, int v) {
  AlberoBinario root=*ptx_root;
  if(root) {
    if(v < root->info) {
      if(root->left) {
        insert(&(root->left), v);
      }
      else {
        AlberoBinario new = malloc(sizeof(struct nodoAlberoBinario));
        new->info = v;
        new->left = NULL;
        new->right = NULL;
        root->left = new;
      }
    }
    else if(v > root->info) {
      if(root->right) {
        insert(&(root->right), v);
      }
      else {
        AlberoBinario new = malloc(sizeof(struct nodoAlberoBinario));
        new->info = v;
        new->left = NULL;
        new->right = NULL;
        root->right = new;
      }
    }
  }
  else {
    AlberoBinario new = malloc(sizeof(struct nodoAlberoBinario));
    new->info = v;
    new->left = NULL;
    new->right = NULL;
    *ptx_root = new;
  }
}

void search(AlberoBinario root, int* k, AlberoBinario* aux) {
  printf("%d %d\n", root->info, *k);
  if((*k) == 0) {
    *aux = root;
    return;
  }
  if(root->left) {
    *k = *k-1;
    search(root->left, k, aux);
  }
  if(root->right) {
    *k = *k-1;
    search(root->right, k, aux);
  }
}

int kth(AlberoBinario root, int k) {
  AlberoBinario aux=root;
  search(root, &k, &aux);
  return aux->info;
}