# include <stdio.h>
# include <stdlib.h>

// List structure :
struct El {
  int info ;
  struct El * next ;
};
typedef struct El Element ;
typedef Element * List ;

// Function and procedure to be implemented
int read ( List * l ) ;
void intersection ( List * l1 , List l2 ) ;

// Function that prints all the elements of the list :
void print ( List list ) {
  printf ("[") ;
  while ( list != NULL ) {
    printf ("%d ", list -> info ) ;
    list = list -> next ;
  }
  printf ("]\n") ;
}

int main () {
  List list1 = NULL , list2 = NULL ;
  int size1 =0 , size2 =0;
  // Read list1 and list2
  size1 = read (& list1 ) ;
  size2 = read (& list2 ) ;
  // Print list1
  printf (" Lista 1 ( Lunghezza : %d)\n", size1 ) ;
  print ( list1 ) ;
  // Print list2
  printf (" Lista 2 ( Lunghezza : %d)\n", size2 ) ;
  print ( list2 ) ;
  // Modify list1 to keep its intersection with list2
  intersection (& list1 , list2 ) ;
  // Print list1 ( modified )
  printf (" Intersezione \n") ;
  print ( list1 ) ;
  return 0;
}




void add_back(List* ptx_head, int v) {
  List head = *ptx_head;
  if(head) {
    while(head->next) {
      head = head->next;
    }

    List new = malloc(sizeof(struct El));
    new->info = v;
    new->next = NULL;
    head->next = new;
  }
  else {
    List new = malloc(sizeof(struct El));
    new->info = v;
    new->next = NULL;
    *ptx_head = new;
  }
}

int read(List* ptx_head) {
  List head = *ptx_head;
  int num, old, k=0;
  scanf("%d", &num);
  old = num-1;
  while(old < num) {
    add_back(ptx_head, num);
    k++;
    old = num;
    scanf("%d", &num);
  }
  return k;
}

int search(List head, int v) {
  while(head) {
    if(head->info == v) return 1;
    head = head->next;
  }
  return 0;
}

void intersection(List* l1, List l2) {
  List Head1=*l1, head1=*l1, head2=l2;
  if(head1->next) {
    List aux=head1;
    head1 = head1->next;

    while(head1) {
      if(!search(head2, head1->info)) {
        aux->next = head1->next;
        free(head1);
        head1 = aux->next;
      }
      else {
        aux = aux->next;
        head1 = head1->next;
      }
    }
  }
  if(Head1) {
    if(!search(head2, Head1->info)) {
      *l1 = Head1->next;
      free(Head1);
    }
  }
}