#ifndef STRS_H_LOADED
#define STRS_H_LOADED

/* strings used in Snd */
#ifndef STR_OR
  #define STR_OR "or"
  /* British spelling enthusiasts can -DSTR_OR=\"our\" */
#endif

#define STRFTIME_FORMAT                  "%a %d-%b-%Y %H:%M %Z"

#define STR_decimal                      '.'
/* defines the decimal point character used where I'm making float representations by hand */

/* '_p' below means it's a prompt or a boolean */

#define STR_Adat_In                      "Adat In"
#define STR_Adat_Out                     "Adat Out"
#define STR_Aes_In                       "Aes In"
#define STR_Aes_Out                      "Aes Out"
#define STR_Analog_In                    "Analog In"
#define STR_Apply		     	 "Apply"
#define STR_Autoload_Recording           "Autoload Recording"
#define STR_Back                         "Back"
#define STR_Big_Trouble                  "Yow!"
#define STR_Cancel			 "Cancel"
#define STR_Channel_style                "Channel style"
#define STR_Clear                        "Clear"
#define STR_Click_for_help		 "Click for help"
#define STR_CLM                          "CLM"
#define STR_Close			 "Close"
#define STR_Color                        "Col" STR_OR
#define STR_Color_Editor                 "Col" STR_OR " Editor"
#define STR_Contrast			 "Contrast"
#define STR_Customization		 "Customization"
#define STR_Default		 	 "Default"
#define STR_Delete			 "Delete"
#define STR_Delete_Selection		 "Delete Selection"
#define STR_Digital_In                   "Digital In"
#define STR_Digital_Out                  "Digital Out"
#define STR_Disk_and_Memory_Usage        "Disk and Memory Usage"
#define STR_Dismiss		         "Dismiss"
#define STR_Done			 "Done"
#define STR_Edit			 "Edit"
#define STR_Edit_Envelope                "Edit Envelope"
#define STR_Edit_Header                  "Edit Header"
#define STR_Edit_header_of               "Edit header of %s"
#define STR_Envelope			 "Envelope"
#define STR_Equalize_Panes		 "Equalize Panes"
#define STR_Error			 "Error"
#define STR_Error_History		 "Error History"
#define STR_Exit			 "Exit"
#define STR_Expand			 "Expand"
#define STR_FFT			         "FFT"
#define STR_File			 "File"
#define STR_File_Browser                 "File Browser"
#define STR_Files			 "Files"
#define STR_Find			 "Find"
#define STR_Focus_style                  "Zoom focus"
#define STR_Format			 "Format"
#define STR_Formats			 "Formats"
#define STR_Forward                      "Forward"
#define STR_Graph_style                  "Graph style"
#define STR_Help			 "Help"
#define STR_Hide_controls	 	 "Hide controls"
#define STR_Hide_listener	         "Hide listener"
#define STR_Hide_Y0			 "Hide Y = 0"
#define STR_Info			 "Info"
#define STR_Input                        "Input"
#define STR_Insert_Selection		 "Insert Selection"
#define STR_Line_In                      "Line In"
#define STR_Line_Out                     "Line Out"
#define STR_Marks			 "Marks"
#define STR_Microphone                   "Microphone"
#define STR_Mix		                 "Mix"
#define STR_Mixing                       "Mixing"
#define STR_Mix_Panel                    "Mix Panel"
#define STR_Mix_Selection		 "Mix Selection"
#define STR_New				 "New"
#define STR_News			 "News"
#define STR_Next			 "Next"
#define STR_No                           "No"
#define STR_No_Header_on_File		 "No Header on File"
#define STR_Ok				 "Ok"
#define STR_Open			 "Open"
#define STR_Open_listener		 "Open listener"
#define STR_Options			 "Options"
#define STR_Orientation                  "Orientation"
#define STR_Output                       "Output"
#define STR_Overview			 "Overview"
#define STR_Play			 "Play"
#define STR_Play_Selection		 "Play Selection"
#define STR_Popup                        "Popup"
#define STR_Print			 "Print"
#define STR_Previous			 "Previous"
#define STR_Raw_Data		 	 "Raw Data"
#define STR_Record			 "Record"
#define STR_Recording			 "Recording"
#define STR_Redo			 "Redo"
#define STR_Region_Browser		 "Region Browser"
#define STR_Regions			 "Regions"
#define STR_Remember			 "Remember"
#define STR_Reset                        "Reset"
#define STR_Restart		         "Restart"
#define STR_Restore		         "Restore"
#define STR_Reverb			 "Reverb"
#define STR_Revert			 "Revert"
#define STR_Save			 "Save"
#define STR_Save_as			 "Save as"
#define STR_Save_Audio_Settings		 "Save Audio Settings"
#define STR_Save_options		 "Save options"
#define STR_Save_Selection     	         "Save Selection"
#define STR_Save_state     	         "Save state"
#define STR_Select			 "Select"
#define STR_Select_all			 "Select all"
#define STR_Show_controls		 "Show controls"
#define STR_Show_listener	         "Show listener"
#define STR_Show_Y0			 "Show Y = 0"
#define STR_Silent_cursor		 "Silent cursor"
#define STR_Sound_Files_Only		 "sound files only"
#define STR_Speakers                     "Speakers"
#define STR_Spectrogram_Orientation	 "Spectrogram Orientation"
#define STR_Speed			 "Speed"
#define STR_Speed_style                  "Speed style"
#define STR_Stop                         "Stop"
#define STR_Sync			 "Sync"
#define STR_Transform_Options            "Transform Options"
#define STR_Triggered_Record		 "Triggered Record"
#define STR_Undo		         "Undo"
#define STR_Undo_and_Apply		 "Undo&Apply"
#define STR_Undo_and_redo		 "Undo and redo"
#define STR_Update                       "Update"
#define STR_Verbose_cursor		 "Verbose cursor"
#define STR_View			 "View"
#define STR_X_axis_units                 "X axis units"
#define STR_Yes                          "Yes"
#define STR_amp			         "amp"
#define STR_amp_p			 "amp:"
#define STR_amp_env_p			 "amp env:"
#define STR_beats                        "beats"
#define STR_channel_id                   "chn"
#define STR_chans                        "chans: %d"
#define STR_chans_p			 "chans:"
#define STR_clip			 "clip"
#define STR_combined                     "combined"
#define STR_comment_p                    "comment:"
#define STR_contrast			 "contrast:"
#define STR_current_files                "current files"
#define STR_current_selection            "current selection"
#define STR_cutoff                       "data cutoff"
#define STR_dark                         "dark"
#define STR_data                         "data"
#define STR_data_format_p		 "data format:"
#define STR_data_location_p		 "data location:"
#define STR_date                         "date"
#define STR_dB                           "dB"
#define STR_direct_to_printer            "direct to printer"
#define STR_display                      "display"
#define STR_dots                         "dots"
#define STR_dots_and_lines               "dots and lines"
#define STR_duration_p                   "duration:"
#define STR_edit                         "edit"
#define STR_edit_env                     "edit env"
#define STR_entry			 "entry"
#define STR_envs_p			 "envs:"
#define STR_eps_file_p			 "eps file:"
#define STR_exp			         "exp"
#define STR_exp_base		         "exp:"
#define STR_expand			 "expand:"
#define STR_f			 	 "f"
/* this 'f' => fft */
#define STR_file_p			 "file:"
#define STR_filled			 "filled"
#define STR_filter			 "filter:"
#define STR_float                        "float"
#define STR_flt			         "flt"
#define STR_flt_env_p			 "flt env:"
#define STR_focus_active                 "cursor or selection"
#define STR_focus_left                   "window left edge"
#define STR_focus_middle                 "window midpoint"
#define STR_focus_right                  "window right edge"
#define STR_frequency			 "frequency"
#define STR_global_search		 "global search"
#define STR_header                       "header"
#define STR_hop                          "hop"
#define STR_invert                       "invert"
#define STR_len				 "len:"
#define STR_length                       "length: %.3f"
#define STR_length_p                     "length:"
/* 'len' => reverb length in the controls panel */
#define STR_light                        "light"
#define STR_linear                       "linear"
#define STR_lines                        "lines"
#define STR_location_p                   "location:"
#define STR_log_freq			 "log freq"
#define STR_lollipops                    "lollipops"
/* using lollipop rather than the suggested popsicle because 
 *   popsicle is a (capitalized) trade-name in the USA and I want lowercase,
 *   lollipop is about 200 years older as an English word (1724 vs 1923),
 *   and I think lollipop is more accurate -- in my experience lollipops have
 *     circular candies whereas popsicles have a sort of squared-off bottom.
 */
#define STR_maxamp                       "maxamp: %.3f"
#define STR_maxamp_p                     "maxamp:"
#define STR_mix_file_p			 "mix file:"
#define STR_name                         "name"
#define STR_no_data                      "(no data)"
#define STR_single_transform	         "single transform"
#define STR_normalize		         "normalize"
#define STR_peaks			 "peaks"
#define STR_percent_of_spectrum          "% of spectrum"
#define STR_percentage                   "percentage"
#define STR_play			 "play"
#define STR_previous_files               "previous files"
#define STR_print                        "print"
#define STR_print_env                    "print env"
#define STR_ratio                        "ratio"
#define STR_redo                         "redo"
#define STR_regions                      "regions"
#define STR_reverb			 "reverb:"
#define STR_revert			 "revert"
#define STR_samples			 "samples"
#define STR_save			 "save"
#define STR_save_as_p			 "save as:"
#define STR_seconds			 "seconds"
#define STR_selection                    "selection"
#define STR_semitone                     "semitones"
#define STR_separate                     "separate"
#define STR_size			 "size"
#define STR_sonogram			 "sonogram"
#define STR_sort                         "sort"
#define STR_spectrogram			 "spectrogram"
#define STR_speed			 "speed:"
#define STR_srate			 "srate: %d"
#define STR_srate_p			 "srate:"
#define STR_src                          "src"
#define STR_src_env_p                    "src env:"
#define STR_superimposed                 "superimposed"
#define STR_sync			 "sync"
#define STR_time			 "time"
#define STR_time_percent                 "time (%)"
#define STR_time_beats                   "time (beats)"
#define STR_time_samples                 "time (samples)"
#define STR_type			 "type"
#define STR_undo                         "undo"
#define STR_unite                        "unite"
#define STR_unlist                       "unlist"
#define STR_view_envs                    "view envs"
#define STR_w				 "w"
/* 'w' => wave (time domain) */
#define STR_wave		         "wave"
#define STR_wavelet                      "wavelet"
#define STR_window		         "window"
#define STR_x_angle                      "x angle"
#define STR_x_scale                      "x scale"
#define STR_y_angle                      "y angle"
#define STR_y_scale                      "y scale"
#define STR_z_angle                      "z angle"
#define STR_z_scale                      "z scale"


#define S_abort                         "abort"
#define S_add_mark                      "add-mark"
#define S_add_player                    "add-player"
#define S_add_sound_file_extension      "add-sound-file-extension"
#define S_add_to_main_menu              "add-to-main-menu"
#define S_add_to_menu                   "add-to-menu"
#define S_add_transform                 "add-transform"
#define S_after_apply_hook              "after-apply-hook"
#define S_after_edit_hook               "after-edit-hook"
#define S_after_graph_hook              "after-graph-hook"
#define S_after_open_hook               "after-open-hook"
#define S_amp_control                   "amp-control"
#define S_append_to_minibuffer          "append-to-minibuffer"
#define S_apply_controls                "apply-controls"
#define S_as_one_edit                   "as-one-edit"
#define S_ask_before_overwrite          "ask-before-overwrite"
#define S_audio_input_device            "audio-input-device"
#define S_audio_output_device           "audio-output-device"
#define S_audio_state_file              "audio-state-file"
#define S_auto_resize                   "auto-resize"
#define S_auto_update                   "auto-update"
#define S_auto_update_interval          "auto-update-interval"
#define S_autocorrelate                 "autocorrelate"
#define S_autocorrelation               "autocorrelation"
#define S_axis_info                     "axis-info"
#define S_axis_label_font               "axis-label-font"
#define S_axis_numbers_font             "axis-numbers-font"
#define S_backward_graph                "backward-graph"
#define S_backward_mark                 "backward-mark"
#define S_backward_mix                  "backward-mix"
#define S_backward_sample               "backward-sample"
#define S_basic_color                   "basic-col" STR_OR
#define S_beats_per_minute              "beats-per-minute"
#define S_before_apply_hook             "before-apply-hook"
#define S_before_transform_hook         "before-transform-hook"
#define S_bind_key                      "bind-key"  
#define S_bold_button_font              "bold-button-font"
#define S_bomb                          "bomb"
#define S_button_font                   "button-font"
#define S_c_g                           "c-g?"
#define S_c_g_x                         "c-g!"
#define S_cepstrum                      "cepstrum"
#define S_change_menu_label             "change-menu-label"
#define S_change_property               "change-property"
#define S_change_samples_with_origin    "change-samples-with-origin"
#define S_channel2vct                   "channel->vct"
#define S_channel_amp_envs              "channel-amp-envs"
#define S_channel_properties            "channel-properties"
#define S_channel_style                 "channel-style"
#define S_channel_widgets               "channel-widgets"
#define S_channels                      "channels"
#define S_channels_combined             "channels-combined"
#define S_channels_separate             "channels-separate"
#define S_channels_superimposed         "channels-superimposed"
#define S_chans                         "chans"
#define S_chebyshev_transform           "chebyshev-transform"
#define S_clear_audio_inputs            "clear-audio-inputs"
#define S_clear_listener                "clear-listener"
#define S_clm_channel                   "clm-channel"
#define S_close_hook                    "close-hook"
#define S_close_sound                   "close-sound"
#define S_close_sound_file              "close-sound-file"
#define S_color2list                    "col" STR_OR "->list"
#define S_color_cutoff                  "col" STR_OR "-cutoff"
#define S_color_dialog                  "col" STR_OR "-dialog"
#define S_color_inverted                "col" STR_OR "-inverted"
#define S_color_p                       "col" STR_OR "?"
#define S_color_scale                   "col" STR_OR "-scale"
#define S_colormap                      "col" STR_OR "map"
#define S_comment                       "comment"
#define S_contrast_control              "contrast-control"
#define S_contrast_control_amp          "contrast-control-amp"
#define S_contrast_control_p            "contrast-control?"
#define S_convolve_arrays               "convolve-arrays"
#define S_convolve_channel              "convolve-channel"
#define S_convolve_selection_with       "convolve-selection-with"
#define S_convolve_with                 "convolve-with"
#define S_copy_context                  "copy-context"
#define S_count_matches                 "count-matches"
#define S_current_edit_position         "current-edit-position"
#define S_current_font                  "current-font"
#define S_cursor                        "cursor"
#define S_cursor_color                  "cursor-col" STR_OR
#define S_cursor_context                "cursor-context"
#define S_cursor_cross                  "cursor-cross"
#define S_cursor_follows_play           "cursor-follows-play"
#define S_cursor_in_middle              "cursor-in-middle"
#define S_cursor_in_view                "cursor-in-view"
#define S_cursor_line                   "cursor-line"
#define S_cursor_on_left                "cursor-on-left"
#define S_cursor_on_right               "cursor-on-right"
#define S_cursor_position               "cursor-position"
#define S_cursor_size                   "cursor-size"
#define S_cursor_style                  "cursor-style"
#define S_dac_combines_channels         "dac-combines-channels"
#define S_dac_hook                      "dac-hook"
#define S_dac_size                      "dac-size"
#define S_data_clipped                  "data-clipped"
#define S_data_color                    "data-col" STR_OR
#define S_data_format                   "data-format"
#define S_data_location                 "data-location"
#define S_default_output_chans          "default-output-chans"
#define S_default_output_format         "default-output-format"
#define S_default_output_srate          "default-output-srate"
#define S_default_output_type           "default-output-type"
#define S_define_envelope               "define-envelope"
#define S_delete_mark                   "delete-mark"
#define S_delete_marks                  "delete-marks"
#define S_delete_sample                 "delete-sample"
#define S_delete_samples                "delete-samples"
#define S_delete_samples_with_origin    "delete-samples-with-origin"
#define S_delete_selection              "delete-selection"
#define S_dialog_widgets                "dialog-widgets"
#define S_dismiss_all_dialogs           "dismiss-all-dialogs"
#define S_display_edits                 "display-edits"
#define S_dont_normalize_transform      "dont-normalize-transform"
#define S_dot_size                      "dot-size"
#define S_draw_axes                     "draw-axes"
#define S_draw_dot                      "draw-dot"
#define S_draw_dots                     "draw-dots"
#define S_draw_line                     "draw-line"
#define S_draw_lines                    "draw-lines"
#define S_draw_mark_hook                "draw-mark-hook"
#define S_draw_string                   "draw-string"
#define S_drop_hook                     "drop-hook"
#define S_during_open_hook              "during-open-hook"
#define S_edit_fragment                 "edit-fragment"
#define S_edit_header_dialog            "edit-header-dialog"
#define S_edit_hook                     "edit-hook"
#define S_edit_position                 "edit-position"
#define S_edit_save_as_dialog           "edit-save-as-dialog"
#define S_edit_tree                     "edit-tree"
#define S_edits                         "edits"
#define S_emacs_style_save_as           "emacs-style-save-as"
#define S_env_channel                   "env-channel"
#define S_env_selection                 "env-selection"
#define S_env_sound                     "env-sound"
#define S_enved_active_env              "enved-active-env"
#define S_enved_add_point               "enved-add-point"
#define S_enved_amplitude               "enved-amplitude"
#define S_enved_base                    "enved-base"
#define S_enved_clip_p                  "enved-clip?"
#define S_enved_delete_point            "enved-delete-point"
#define S_enved_dialog                  "enved-dialog"
#define S_enved_exp_p                   "enved-exp?"
#define S_enved_filter_order            "enved-filter-order"
#define S_enved_filter                  "enved-filter"
#define S_enved_hook                    "enved-hook"
#define S_enved_in_dB                   "enved-in-dB"
#define S_enved_move_point              "enved-move-point"
#define S_enved_power                   "enved-power"
#define S_enved_selected_env            "enved-selected-env"
#define S_enved_spectrum                "enved-spectrum"
#define S_enved_srate                   "enved-srate"
#define S_enved_target                  "enved-target"
#define S_enved_wave_p                  "enved-wave?"
#define S_enved_waveform_color          "enved-waveform-col" STR_OR
#define S_eps_bottom_margin             "eps-bottom-margin"
#define S_eps_file                      "eps-file"
#define S_eps_left_margin               "eps-left-margin"
#define S_eps_size                      "eps-size"
#define S_equalize_panes                "equalize-panes"
#define S_exit                          "exit"
#define S_exit_hook                     "exit-hook"
#define S_expand_control                "expand-control"
#define S_expand_control_hop            "expand-control-hop"
#define S_expand_control_length         "expand-control-length"
#define S_expand_control_p              "expand-control?"
#define S_expand_control_ramp           "expand-control-ramp"
#define S_fft                           "fft"
#define S_fft_log_frequency             "fft-log-frequency"
#define S_fft_log_magnitude             "fft-log-magnitude"
#define S_fft_window                    "fft-window"
#define S_fft_window_beta               "fft-window-beta"
#define S_fht                           "fht"
#define S_file_dialog                   "file-dialog"
#define S_file_name                     "file-name"
#define S_file_save_as_dialog           "file-save-as-dialog"
#define S_fill_polygon                  "fill-polygon"
#define S_fill_rectangle                "fill-rectangle"
#define S_filter_channel                "filter-channel"
#define S_filter_control_env            "filter-control-env"
#define S_filter_control_in_dB          "filter-control-in-dB"
#define S_filter_control_order          "filter-control-order"
#define S_filter_control_p              "filter-control?"
#define S_filter_env_in_hz              "filter-env-in-hz"
#define S_filter_selection              "filter-selection"
#define S_filter_sound                  "filter-sound"
#define S_filter_waveform_color         "filter-waveform-col" STR_OR
#define S_find                          "find"
#define S_find_mark                     "find-mark"
#define S_find_mix                      "find-mix"
#define S_find_sound                    "find-sound"
#define S_finish_progress_report        "finish-progress-report"
#define S_focus_widget                  "focus-widget"
#define S_foreground_color              "foreground-col" STR_OR
#define S_forget_region                 "forget-region"
#define S_forward_graph                 "forward-graph"
#define S_forward_mark                  "forward-mark"
#define S_forward_mix                   "forward-mix"
#define S_forward_sample                "forward-sample"
#define S_fourier_transform             "fourier-transform"
#define S_frames                        "frames"
#define S_free_mix_sample_reader        "free-mix-sample-reader"
#define S_free_sample_reader            "free-sample-reader"
#define S_free_track_sample_reader      "free-track-sample-reader"
#define S_graph                         "graph"
#define S_graph2ps                      "graph->ps"
#define S_graph_color                   "graph-col" STR_OR
#define S_graph_cursor                  "graph-cursor"
#define S_graph_data                    "graph-data"
#define S_graph_dots                    "graph-dots"
#define S_graph_dots_and_lines          "graph-dots-and-lines"
#define S_graph_filled                  "graph-filled"
#define S_graph_hook                    "graph-hook"
#define S_graph_lines                   "graph-lines"
#define S_graph_lisp_p                  "graph-lisp?"
#define S_graph_lollipops               "graph-lollipops"
#define S_graph_style                   "graph-style"
#define S_graph_time_once               "graph-time-once"
#define S_graph_time_as_wavogram        "graph-time-as-wavogram"
#define S_graph_time_p                  "graph-time?"
#define S_graph_transform_as_sonogram   "graph-transform-as-sonogram"
#define S_graph_transform_as_spectrogram "graph-transform-as-spectrogram"
#define S_graph_transform_once          "graph-transform-once"
#define S_graph_transform_p             "graph-transform?"
#define S_graphs_horizontal             "graphs-horizontal"
#define S_haar_transform                "haar-transform"
#define S_hadamard_transform            "hadamard-transform"
#define S_hankel_jn                     "hankel-jn"
#define S_hankel_transform              "hankel-transform"
#define S_header_type                   "header-type"
#define S_help_dialog                   "help-dialog"
#define S_help_hook                     "help-hook"
#define S_help_text_font                "help-text-font"
#define S_hide_widget                   "hide-widget"
#define S_highlight_color               "highlight-col" STR_OR
#define S_html_dir                      "html-dir"
#define S_in                            "in"
#define S_initial_graph_hook            "initial-graph-hook"
#define S_insert_region                 "insert-region"
#define S_insert_sample                 "insert-sample"
#define S_insert_samples                "insert-samples"
#define S_insert_samples_with_origin    "insert-samples-with-origin"
#define S_insert_selection              "insert-selection"
#define S_insert_silence                "insert-silence"
#define S_insert_sound                  "insert-sound"
#define S_just_sounds                   "just-sounds"
#define S_just_sounds_hook              "just-sounds-hook"
#define S_key                           "key"
#define S_key_binding                   "key-binding"
#define S_key_press_hook                "key-press-hook"
#define S_keyboard_no_action            "keyboard-no-action"
#define S_ladspa_dir                    "ladspa-dir"
#define S_left_sample                   "left-sample"
#define S_lisp_graph                    "lisp-graph"
#define S_lisp_graph_hook               "lisp-graph-hook"
#define S_listener_color                "listener-col" STR_OR
#define S_listener_font                 "listener-font"
#define S_listener_prompt               "listener-prompt"
#define S_listener_selection            "listener-selection"
#define S_listener_text_color           "listener-text-col" STR_OR
#define S_load_font                     "load-font"
#define S_loop_samples                  "loop-samples"
#define S_main_menu                     "main-menu"
#define S_main_widgets                  "main-widgets"
#define S_make_color                    "make-col" STR_OR
#define S_make_graph_data               "make-graph-data"
#define S_make_mix_sample_reader        "make-mix-sample-reader"
#define S_make_player                   "make-player"
#define S_make_region                   "make-region"
#define S_make_region_sample_reader     "make-region-sample-reader"
#define S_make_sample_reader            "make-sample-reader"
#define S_make_track_sample_reader      "make-track-sample-reader"
#define S_map_chan                      "map-chan"
#define S_map_channel                   "map-channel"
#define S_mark_click_hook               "mark-click-hook"
#define S_mark_color                    "mark-col" STR_OR
#define S_mark_context                  "mark-context"
#define S_mark_drag_hook                "mark-drag-hook"
#define S_mark_home                     "mark-home"
#define S_mark_hook                     "mark-hook"
#define S_mark_name                     "mark-name"
#define S_mark_p                        "mark?"
#define S_mark_sample                   "mark-sample"
#define S_mark_sync                     "mark-sync"
#define S_mark_sync_max                 "mark-sync-max"
#define S_marks                         "marks"
#define S_max_regions                   "max-regions"
#define S_max_sounds                    "max-sounds"
#define S_max_transform_peaks           "max-transform-peaks"
#define S_maxamp                        "maxamp"
#define S_memo_sound                    "memo-sound"
#define S_menu_hook                     "menu-hook"
#define S_menu_sensitive                "menu-sensitive"
#define S_menu_widgets                  "menu-widgets"
#define S_min_dB                        "min-dB"
#define S_minibuffer_history_length     "minibuffer-history-length"
#define S_mix                           "mix"
#define S_mix_amp                       "mix-amp"
#define S_mix_amp_changed_hook          "mix-amp-changed-hook"
#define S_mix_amp_env                   "mix-amp-env"
#define S_mix_anchor                    "mix-anchor"
#define S_mix_chans                     "mix-chans"
#define S_mix_color                     "mix-col" STR_OR
#define S_mix_file_dialog               "mix-file-dialog"
#define S_mix_home                      "mix-home"
#define S_mix_length                    "mix-length"
#define S_mix_locked                    "mix-locked"
#define S_mix_name                      "mix-name"
#define S_mix_p                         "mix?"
#define S_mix_panel                     "mix-panel"
#define S_mix_position                  "mix-position"
#define S_mix_position_changed_hook     "mix-position-changed-hook"
#define S_mix_region                    "mix-region"
#define S_mix_sample_reader_home        "mix-sample-reader-home"
#define S_mix_sample_reader_p           "mix-sample-reader?"
#define S_mix_selection                 "mix-selection"
#define S_mix_sound                     "mix-sound"
#define S_mix_speed                     "mix-speed"
#define S_mix_speed_changed_hook        "mix-speed-changed-hook"
#define S_mix_tag_height                "mix-tag-height"
#define S_mix_tag_width                 "mix-tag-width"
#define S_mix_tag_y                     "mix-tag-y"
#define S_mix_track                     "mix-track"
#define S_mix_vct                       "mix-vct"
#define S_mix_waveform_height           "mix-waveform-height"
#define S_mixes                         "mixes"
#define S_mouse_click_hook              "mouse-click-hook"
#define S_mouse_drag_hook               "mouse-drag-hook"
#define S_mouse_enter_graph_hook        "mouse-enter-graph-hook"
#define S_mouse_enter_label_hook        "mouse-enter-label-hook"
#define S_mouse_enter_listener_hook     "mouse-enter-listener-hook"
#define S_mouse_enter_text_hook         "mouse-enter-text-hook"
#define S_mouse_leave_graph_hook        "mouse-leave-graph-hook"
#define S_mouse_leave_label_hook        "mouse-leave-label-hook"
#define S_mouse_leave_listener_hook     "mouse-leave-listener-hook"
#define S_mouse_leave_text_hook         "mouse-leave-text-hook"
#define S_mouse_press_hook              "mouse-press-hook"
#define S_mouse_release_hook            "mouse-release-hook"
#define S_multichannel_mix_hook         "multichannel-mix-hook"
#define S_mus_error_hook                "mus-error-hook"
#define S_name_click_hook               "name-click-hook"
#define S_new_sound                     "new-sound"
#define S_new_widget_hook               "new-widget-hook"
#define S_next_mix_sample               "next-mix-sample"
#define S_next_sample                   "next-sample"
#define S_next_track_sample             "next-track-sample"
#define S_normalize_transform_by_channel "normalize-transform-by-channel"
#define S_normalize_transform_by_sound  "normalize-transform-by-sound"
#define S_normalize_transform_globally  "normalize-transform-globally"
#define S_open_file_dialog              "open-file-dialog"
#define S_open_hook                     "open-hook"
#define S_open_raw_sound                "open-raw-sound"
#define S_open_raw_sound_hook           "open-raw-sound-hook"
#define S_open_sound                    "open-sound"
#define S_open_sound_file               "open-sound-file"
#define S_optimization                  "optimization"
#define S_optimization_hook             "optimization-hook"
#define S_orientation_dialog            "orientation-dialog"
#define S_oss_buffers                   "oss-buffers"
#define S_output_comment_hook           "output-comment-hook"
#define S_output_name_hook              "output-name-hook"
#define S_pad_channel                   "pad-channel"
#define S_peak_env_info                 "peak-env-info"
#define S_peaks                         "peaks"
#define S_play                          "play"
#define S_play_and_wait                 "play-and-wait"
#define S_play_channel                  "play-channel"
#define S_play_hook                     "play-hook"
#define S_play_mix                      "play-mix"
#define S_play_region                   "play-region"
#define S_play_selection                "play-selection"
#define S_play_track                    "play-track"
#define S_player_home                   "player-home"
#define S_player_p                      "player?"
#define S_position2x                    "position->x"
#define S_position2y                    "position->y"
#define S_position_color                "position-col" STR_OR
#define S_preload_directory             "preload-directory"
#define S_preload_file                  "preload-file"
#define S_previous_files_select_hook    "previous-files-select-hook"
#define S_previous_files_sort           "previous-files-sort"
#define S_previous_files_sort_procedure "previous-files-sort-procedure"
#define S_previous_sample               "previous-sample"
#define S_print_hook                    "print-hook"
#define S_print_length                  "print-length"
#define S_progress_report               "progress-report"
#define S_prompt_in_minibuffer          "prompt-in-minibuffer"
#define S_property_changed_hook         "property-changed-hook"
#define S_protect_region                "protect-region"
#define S_pushed_button_color           "pushed-button-col" STR_OR
#define S_ramp_channel                  "ramp-channel"
#define S_read_hook                     "read-hook"
#define S_read_only                     "read-only"
#define S_read_peak_env_info_file       "read-peak-env-info-file"
#define S_read_sample                   "read-sample"
#define S_read_mix_sample               "read-mix-sample"
#define S_read_track_sample             "read-track-sample"
#define S_recolor_widget                "recol" STR_OR "-widget"
#define S_recorder_autoload             "recorder-autoload"
#define S_recorder_buffer_size          "recorder-buffer-size"
#define S_recorder_dialog               "recorder-dialog"
#define S_recorder_file                 "recorder-file"
#define S_recorder_gain                 "recorder-gain"
#define S_recorder_in_amp               "recorder-in-amp"
#define S_recorder_in_format            "recorder-in-format"
#define S_recorder_in_device            "recorder-in-device"
#define S_recorder_max_duration         "recorder-max-duration"
#define S_recorder_out_amp              "recorder-out-amp"
#define S_recorder_out_chans            "recorder-out-chans"
#define S_recorder_out_format           "recorder-out-format"
#define S_recorder_srate                "recorder-srate"
#define S_recorder_trigger              "recorder-trigger"
#define S_redo                          "redo"
#define S_region_chans                  "region-chans"
#define S_region_dialog                 "region-dialog"
#define S_region_graph_style            "region-graph-style"
#define S_region_length                 "region-length"
#define S_region_maxamp                 "region-maxamp"
#define S_region_p                      "region?"
#define S_region_sample                 "region-sample"
#define S_region_samples                "region-samples"
#define S_region_samples2vct            "region-samples->vct"
#define S_region_srate                  "region-srate"
#define S_regions                       "regions"
#define S_remove_from_menu              "remove-from-menu"
#define S_report_in_minibuffer          "report-in-minibuffer"
#define S_reset_controls                "reset-controls"
#define S_reset_listener_cursor         "reset-listener-cursor"
#define S_restore_controls              "restore-controls"
#define S_restore_marks                 "restore-marks"
#define S_restore_region                "restore-region"
#define S_reverb_control_decay          "reverb-control-decay"
#define S_reverb_control_feedback       "reverb-control-feedback"
#define S_reverb_control_length         "reverb-control-length"
#define S_reverb_control_lowpass        "reverb-control-lowpass"
#define S_reverb_control_p              "reverb-control?"
#define S_reverb_control_scale          "reverb-control-scale"
#define S_reverse_channel               "reverse-channel"
#define S_reverse_selection             "reverse-selection"
#define S_reverse_sound                 "reverse-sound"
#define S_revert_sound                  "revert-sound"
#define S_right_sample                  "right-sample"
#define S_sample                        "sample"
#define S_sample_reader_at_end_p        "sample-reader-at-end?"
#define S_sample_reader_home            "sample-reader-home"
#define S_sample_reader_p               "sample-reader?"
#define S_samples                       "samples"
#define S_samples2sound_data            "samples->sound-data"
#define S_samples2vct                   "samples->vct"
#define S_sash_color                    "sash-col" STR_OR
#define S_save_controls                 "save-controls"
#define S_save_dir                      "save-dir"
#define S_save_edit_history             "save-edit-history"
#define S_save_envelopes                "save-envelopes"
#define S_save_hook                     "save-hook"
#define S_save_listener                 "save-listener"
#define S_save_macros                   "save-macros"
#define S_save_marks                    "save-marks"
#define S_save_options                  "save-options"
#define S_save_region                   "save-region"
#define S_save_selection                "save-selection"
#define S_save_sound                    "save-sound"
#define S_save_sound_as                 "save-sound-as"
#define S_save_state                    "save-state"
#define S_save_state_file               "save-state-file"
#define S_scale_by                      "scale-by"
#define S_scale_channel                 "scale-channel"
#define S_scale_selection_by            "scale-selection-by"
#define S_scale_selection_to            "scale-selection-to"
#define S_scale_sound_by                "scale-sound-by"
#define S_scale_sound_to                "scale-sound-to"
#define S_scale_to                      "scale-to" 
#define S_scan_chan                     "scan-chan"
#define S_scan_channel                  "scan-channel"
#define S_script_arg                    "script-arg"
#define S_script_args                   "script-args"
#define S_search_procedure              "search-procedure"
#define S_select_all                    "select-all"
#define S_select_channel                "select-channel"
#define S_select_channel_hook           "select-channel-hook"
#define S_select_mix                    "select-mix"
#define S_select_mix_hook               "select-mix-hook"
#define S_select_sound                  "select-sound"
#define S_select_sound_hook             "select-sound-hook"
#define S_selected_channel              "selected-channel"
#define S_selected_data_color           "selected-data-col" STR_OR
#define S_selected_graph_color          "selected-graph-col" STR_OR
#define S_selected_mix                  "selected-mix"
#define S_selected_mix_color            "selected-mix-col" STR_OR
#define S_selected_sound                "selected-sound"
#define S_selection_chans               "selection-chans"
#define S_selection_color               "selection-col" STR_OR
#define S_selection_context             "selection-context"
#define S_selection_creates_region      "selection-creates-region"
#define S_selection_length              "selection-length"
#define S_selection_maxamp              "selection-maxamp"
#define S_selection_member              "selection-member?"
#define S_selection_p                   "selection?"
#define S_selection_position            "selection-position"
#define S_selection_srate               "selection-srate"
#define S_short_file_name               "short-file-name"
#define S_show_all_axes                 "show-all-axes"
#define S_show_axes                     "show-axes"
#define S_show_backtrace                "show-backtrace"
#define S_show_controls                 "show-controls"
#define S_show_indices                  "show-indices"
#define S_show_listener                 "show-listener"
#define S_show_marks                    "show-marks"
#define S_show_mix_waveforms            "show-mix-waveforms"
#define S_show_no_axes                  "show-no-axes"
#define S_show_selection_transform      "show-selection-transform"
#define S_show_transform_peaks          "show-transform-peaks"
#define S_show_widget                   "show-widget"
#define S_show_x_axis                   "show-x-axis"
#define S_show_y_zero                   "show-y-zero"
#define S_sinc_width                    "sinc-width"
#define S_smooth_channel                "smooth-channel"
#define S_smooth_selection              "smooth-selection"
#define S_smooth_sound                  "smooth-sound"
#define S_snd_apropos                   "snd-apropos"
#define S_snd_error                     "snd-error"
#define S_snd_error_hook                "snd-error-hook"
#define S_snd_gcs                       "snd-gcs"
#define S_snd_help                      "snd-help"
#define S_snd_pixel                     "snd-pixel"
#define S_snd_print                     "snd-print"
#define S_snd_spectrum                  "snd-spectrum"
#define S_snd_tempnam                   "snd-tempnam"
#define S_snd_version                   "snd-version"
#define S_snd_warning                   "snd-warning"
#define S_snd_warning_hook              "snd-warning-hook"
#define S_sound_files_in_directory      "sound-files-in-directory"
#define S_sound_loop_info               "sound-loop-info"
#define S_sound_p                       "sound?"
#define S_sound_properties              "sound-properties"
#define S_sound_widgets                 "sound-widgets"
#define S_soundfont_info                "soundfont-info"
#define S_sounds                        "sounds"
#define S_spectro_cutoff                "spectro-cutoff"
#define S_spectro_hop                   "spectro-hop"
#define S_spectro_start                 "spectro-start"
#define S_spectro_x_angle               "spectro-x-angle"
#define S_spectro_x_scale               "spectro-x-scale"
#define S_spectro_y_angle               "spectro-y-angle"
#define S_spectro_y_scale               "spectro-y-scale"
#define S_spectro_z_angle               "spectro-z-angle"
#define S_spectro_z_scale               "spectro-z-scale"
#define S_speed_control                 "speed-control"
#define S_speed_control_as_float        "speed-control-as-float"
#define S_speed_control_as_ratio        "speed-control-as-ratio"
#define S_speed_control_as_semitone     "speed-control-as-semitone"
#define S_speed_control_style           "speed-control-style"
#define S_speed_control_tones           "speed-control-tones"
#define S_squelch_update                "squelch-update"
#define S_srate                         "srate"
#define S_src_channel                   "src-channel"
#define S_src_selection                 "src-selection"
#define S_src_sound                     "src-sound"
#define S_start_hook                    "start-hook"
#define S_start_playing                 "start-playing"
#define S_start_playing_hook            "start-playing-hook"
#define S_start_progress_report         "start-progress-report"
#define S_stop_dac_hook                 "stop-dac-hook"
#define S_stop_player                   "stop-player"
#define S_stop_playing                  "stop-playing"
#define S_stop_playing_channel_hook     "stop-playing-channel-hook"
#define S_stop_playing_hook             "stop-playing-hook"
#define S_stop_playing_region_hook      "stop-playing-region-hook"
#define S_stop_playing_selection_hook   "stop-playing-selection-hook"
#define S_swap_channels                 "swap-channels"
#define S_sync                          "sync"
#define S_syncd_marks                   "syncd-marks"
#define S_temp_dir                      "temp-dir"
#define S_text_focus_color              "text-focus-col" STR_OR
#define S_time_graph                    "time-graph"
#define S_time_graph_type               "time-graph-type"
#define S_tiny_font                     "tiny-font"
#define S_track_sample_reader_p         "track-sample-reader?"
#define S_transform_dialog              "transform-dialog"
#define S_transform_graph               "transform-graph"
#define S_transform_graph_type          "transform-graph-type"
#define S_transform_hook                "transform-hook"
#define S_transform_normalization       "transform-normalization"
#define S_transform_sample              "transform-sample"
#define S_transform_samples             "transform-samples"
#define S_transform_samples_size        "transform-samples-size"
#define S_transform_samples2vct         "transform-samples->vct"
#define S_transform_size                "transform-size"
#define S_transform_type                "transform-type"
#define S_trap_segfault                 "trap-segfault"
#define S_unbind_key                    "unbind-key"  
#define S_undo                          "undo"
#define S_undo_hook                     "undo-hook"
#define S_update_lisp_graph             "update-lisp-graph"
#define S_update_sound                  "update-sound"
#define S_update_time_graph             "update-time-graph"
#define S_update_transform              "update-transform"
#define S_use_sinc_interp               "use-sinc-interp"
#define S_vct2channel                   "vct->channel"
#define S_vct2samples                   "vct->samples"
#define S_vct2sound_file                "vct->sound-file"
#define S_verbose_cursor                "verbose-cursor"
#define S_view_sound                    "view-sound"
#define S_vu_font                       "vu-font"
#define S_vu_font_size                  "vu-font-size"
#define S_vu_size                       "vu-size"
#define S_walsh_transform               "walsh-transform"
#define S_wavelet_transform             "wavelet-transform"
#define S_wavelet_type                  "wavelet-type"
#define S_wavo_hop                      "wavo-hop"
#define S_wavo_trace                    "wavo-trace"
#define S_widget_position               "widget-position"
#define S_widget_size                   "widget-size"
#define S_widget_text                   "widget-text"
#define S_window_height                 "window-height"
#define S_window_width                  "window-width"
#define S_window_x                      "window-x"
#define S_window_y                      "window-y"
#define S_with_background_processes     "with-background-processes"
#define S_with_mix_tags                 "with-mix-tags"
#define S_write_peak_env_info_file      "write-peak-env-info-file"
#define S_x2position                    "x->position"
#define S_x_axis_as_percentage          "x-axis-as-percentage"
#define S_x_axis_in_beats               "x-axis-in-beats"
#define S_x_axis_in_samples             "x-axis-in-samples"
#define S_x_axis_in_seconds             "x-axis-in-seconds"
#define S_x_axis_style                  "x-axis-style"
#define S_x_bounds                      "x-bounds"
#define S_x_position_slider             "x-position-slider"
#define S_x_zoom_slider                 "x-zoom-slider"
#define S_y2position                    "y->position"
#define S_y_bounds                      "y-bounds"
#define S_y_position_slider             "y-position-slider"
#define S_y_zoom_slider                 "y-zoom-slider"
#define S_yes_or_no_p                   "yes-or-no?"
#define S_zero_pad                      "zero-pad"
#define S_zoom_color                    "zoom-col" STR_OR
#define S_zoom_focus_active             "zoom-focus-active"
#define S_zoom_focus_left               "zoom-focus-left"
#define S_zoom_focus_middle             "zoom-focus-middle"
#define S_zoom_focus_right              "zoom-focus-right"
#define S_zoom_focus_style              "zoom-focus-style"

#endif
